<!DOCTYPE html>
<!--[if lt IE 7]> <html dir="ltr" lang="en-US" class="ie6"> <![endif]-->
<!--[if IE 7]>    <html dir="ltr" lang="en-US" class="ie7"> <![endif]-->
<!--[if IE 8]>    <html dir="ltr" lang="en-US" class="ie8"> <![endif]-->
<!--[if gt IE 8]><!--> <html dir="ltr" lang="en-US"> <!--<![endif]-->

<!-- BEGIN head -->
<head>

	<!--Meta Tags-->
	<meta name="viewport" content="width=device-width; initial-scale=1.0">
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		
	<!--Title-->
	<title>Xuân Phú Hotel - Khách Sạn Xuân Phú</title>

	<!--Stylesheets-->
	<link rel="stylesheet" href="<?php echo e(Asset('public/template/css/superfish.css')); ?>" type="text/css"  media="all"  />
	<link rel="stylesheet" href="<?php echo e(Asset('public/template/css/prettyPhoto.css')); ?>" type="text/css" media="all" />
	<link rel="stylesheet" href="<?php echo e(Asset('public/template/css/responsive.css')); ?>" type="text/css" media="all" />
	<link type="text/css"  href="<?php echo e(Asset('public/template/css/jqueryui/jquery.ui.datepicker.css')); ?>" rel="stylesheet" />
	<link rel="stylesheet" href="<?php echo e(Asset('public/template/style.css')); ?>" type="text/css"  media="all"  />
	<link rel="stylesheet" href="<?php echo e(Asset('public/template/css/colours/cream-red.css')); ?>" type="text/css"  media="all"  />
	<link href='http://fonts.googleapis.com/css?family=Cardo:400,400italic,700' rel='stylesheet' type='text/css'>

	<!--Favicon-->
	<link rel="shortcut icon" href="favicon.ico" type="image/x-icon" />

	<!--JavaScript-->
	<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.7/jquery.min.js"></script>
	<script type='text/javascript' src='http://ajax.googleapis.com/ajax/libs/jqueryui/1.8/jquery-ui.min.js'></script>
	<script type="text/javascript" src="<?php echo e(Asset('public/template/js/jquery.ui.core.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(Asset('public/template/js/jquery.ui.widget.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(Asset('public/template/js/jquery.ui.datepicker.js')); ?>"></script>
	<script type='text/javascript' src="<?php echo e(Asset('public/template/js/jquery.prettyPhoto.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(Asset('public/template/js/superfish.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(Asset('public/template/js/slides.min.jquery.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(Asset('public/template/js/scripts.js')); ?>"></script>
	
	<!--[if (gte IE 6)&(lte IE 8)]>
		<script type="text/javascript" src="js/selectivizr-min.js"></script>
	<![endif]-->

<!-- END head -->
</head>

<!-- BEGIN body -->
<body>

	<!-- BEGIN .background-wrapper -->
	<div class="background-wrapper">
		
		<!-- BEGIN .content-wrapper -->
		<div class="content-wrapper">
		
			<!-- BEGIN .content-body -->
			<div class="content-body">
				
				<!-- BEGIN #header-google-map -->
				<div id="header-google-map" style="display:none;">
					<script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=false"></script>
					<script type="text/javascript" src="<?php echo e(Asset('public/template/js/gmap.js')); ?>"></script>
					<div id="map_canvas" style="width:100%;height:300px;"></div>
				<!-- END #header-google-map -->
				</div>
				
				<!-- BEGIN .top-bar -->
				<div class="top-bar clearfix">
					
					<!-- BEGIN .social-icons -->
					<ul class="social-icons fl">
						<li><a href="#"><span id="facebook_icon"></span></a></li>
						<li><a href="#"><span id="googleplus_icon"></span></a></li>
						<li><a href="#"><span id="skype_icon"></span></a></li>
						<li><a href="#"><span id="flickr_icon"></span></a></li>
					<!-- END .social-icons -->
					</ul>
					
					<!-- BEGIN .gmap-btn-wrapper -->
					<div class="gmap-btn-wrapper">
						<a href="#" class="gmap-btn"></a>
						<div class="gmap-curve"></div>
					<!-- END .gmap-btn-wrapper -->
					</div>
					
					<!-- BEGIN .top-menu-wrapper -->
					<div class="top-menu-wrapper fr clearfix">
						<a href="accommodation.html" class="bookbutton">Book Now</a>
						<!-- <ul class="top-menu fr">
							<li><a href="#">En</a><span> /</span></li>
							<li><a href="#">Vn</a></li>
						</ul> -->
					<!-- END .top-menu-wrapper -->
					</div>
					
				<!-- END .top-bar -->
				</div>
				
				<!-- BEGIN .title-wrapper -->
				<div id="title-wrapper">
					<h1><div class="title-dec-left"></div><a href="index.html">Xuân Phú Hotel <span>Khách Sạn Xuân Phú</span></a><div class="title-dec-right"></div></h1>
				<!-- END .title-wrapper -->
				</div>
				
				<!-- BEGIN #navigation -->
				<div id="navigation" class="clearfix">
					
					<!-- BEGIN #main-menu -->
					<ul id="main-menu" class="fl clearfix">
						<li class="current-menu-item"><a href="index.html">Trang chủ<span>start here</span></a></li>
						<li><a href="accommodation.html">Loại phòng<span>rates &amp; reservations</span></a>
							<ul>
								<li><a href="accommodation-single.html">Single Standard Room</a></li>
								<li><a href="accommodation-single.html">Double Standard Room</a></li>
								<li><a href="accommodation-single.html">Single Ensuite Room</a>
									<ul>
										<li><a href="accommodation-single.html">Single Standard Room</a></li>
										<li><a href="accommodation-single.html">Double Standard Room</a></li>
										<li><a href="accommodation-single.html">Single Ensuite Room</a>
									</ul>
								</li>
								<li><a href="accommodation-single.html">Double Ensuite Room</a></li>
							</ul>
						</li>
						<li><a href="typography.html">Khám phá Đà Nẵng<span>explore Da Nang</span></a>
							<ul>
								<li><a href="blog-single.html">Tin tức & Sự kiện</a></li>
								<li><a href="blog-single.html">Quán ngon Đà Thành</a></li>
								<li><a href="gallery.html">Thư viện Hình ảnh</a>								
							</ul>
						</li>
						<li><a href="events.html">Khuyến mãi<span>what's happening</span></a></li>
						<li><a href="contact.html">Liên hệ<span>get in touch</span></a></li>
					<!-- END #main-menu -->
					</ul>
					
					<ul class="main-menu-contact-info fr">
						<li class="info-phone">05113.66.88.16</li>
						<li class="info-email">maixphu@gmail.com</li>
					</ul>
					
					<div class="corner-left"></div>
					<div class="corner-right"></div>
					
				<!-- END #navigation -->
				</div>
				
				<!-- BEGIN #slides -->
				<div id="slides" class="slide-loader">
					
					<!-- BEGIN .slides_container -->
					<div class="slides_container">
						
						<div class="slide">
							<img src="<?php echo e(Asset('public/template/images/slide1.png')); ?>" alt="" />
							<div class="caption">Delux Double Ensuite Room</div>
						</div>
					
						<div class="slide">
							<a href="accommodation-single.html"><img src="<?php echo e(Asset('public/template/images/slide1.png')); ?>" alt="" /></a>
							<div class="caption">Delux Double Ensuite Room</div>
						</div>
				
					<!-- END .slides_container -->
					</div>

					<a href="#" class="prev">Previous</a>
					<a href="#" class="next">Next</a>
					
					<!-- BEGIN .booknow -->
					<div class="booknow">
						
						<form class="booking-form" name="bookroom" action="booking.html" method="post">
							
							<div class="select-wrapper">
								<select id="room" name="room">
									<option>Select a Room...</option>
									<option>Single Standard Room</option>
									<option>Double Standard Room</option>
									<option>Single Ensuite Room</option>
									<option>Double Ensuite Room</option>
								</select>
							</div>
							
							<div class="clearfix">
								<input type="text" id="datefrom" value="From" class="input-half datepicker">
								<input type="text" id="dateto" value="To" class="input-half input-half-last datepicker">
							</div>
						
							<input class="bookbutton" type="submit" value="ĐẶT PHÒNG" />
						
						</form>
						
						<div class="corner-left"></div>
					<!-- END .booknow -->
					</div>
			
				<!-- END #slides -->
				</div>
			
				<h2 class="intro-msg">Xuân Phú Hotel là một khách sạn hiện đại và đẳng cấp. Tọa lạc ở vị trí đắc địa tại trung tâm quận Liên Chiểu và nằm ngay sát biển. Quý khách dễ dàng ngắm bình minh trên biển tận hưởng sự sôi động của con đường du lịch Nguyễn Tất Thành khi đêm về.</h2>
				
				<hr>

				<!-- BEGIN .section -->
				<div class="section home-blocks clearfix">

					<div class="one-third-full">	
						<h3 class="title1">Tin tức & sự kiện<span class="title-end"></span></h3>
						<p><div class="block-img1"><img src="images/news.jpg" alt="" /></div></p>
						<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean ac tortor at tellus feugiat congue quis ut nunc.</p>
						<p><a href="#" class="button2">More Info &raquo;</a></p>			
					</div>

					<div class="one-third-full featured-wrapper">
						<h3 class="title1">Tiện nghi Khách sạn<span class="title-end"></span></h3>
						<ul class="list3">
							<li>20 phòng khách tiện nghi hiện đại</li>
							<li>Thang máy</li>
							<li>Cho thuê xe</li>
							<li>Đưa đón tại sân bay</li>
							<li>Wifi miễn phí</li>
							<li>Bãi đậu xe</li>
						</ul>
						<div class="featured-bottom"></div>	
					</div>

					<style type="text/css">
						#pimg{
							width: 278px;
    						height: 80px;
						}						
					</style>
					
					<div class="one-third-full">	
						<h3 class="title1">Lý do chọn Xuân Phú Hotel?<span class="title-end"></span></h3>
						<p><div class="block-img1"><img id="pimg" src="images/why.png" alt="" /></div></p>
						<p>Dễ chơi và dễ trúng thưởng. Haha. Aenean ac tortor at tellus feugiat congue quis ut nunc. </p>
						<p><a href="#" class="button2">More Info &raquo;</a></p>			
					</div>

				<!-- END .section -->
				</div>
				
				<hr>
				
				<!-- BEGIN .section -->
				<div class="section clearfix">
					
					<!-- BEGIN .one-half-full -->
					<div class="one-half-full">	
						
						<div class="testimonial-wrapper clearfix">
							<img src="images/guest.png" alt="" class="testimonial-guest" />
							<p class="testimonial-text">&ldquo;Me and my wife had a delightful weekend get away here, the staff were so friendly and attentive. Highly Recommended&rdquo;</p>
							<div class="testimonial-speech"></div>
						</div>
						
						<p class="testimonial-author">Dave Jones - <span>Double Ensuite Room</span></p>
					
					<!-- END .one-half-full -->			
					</div>
					
					<!-- BEGIN .one-half-full .last-col-full -->
					<div class="one-half-full last-col-full">	
						
						<div class="testimonial-wrapper clearfix">
							<img src="images/guest.png" alt="" class="testimonial-guest" />
							<p class="testimonial-text">&ldquo;If you’re looking for a top quality hotel look no further. We were upgraded free of charge to the Premium Suite, thanks so much&rdquo;</p>
							<div class="testimonial-speech"></div>
						</div>
						
						<p class="testimonial-author">Tim Smith - <span>Premium Suite Room</span></p>
					
					<!-- END .one-half-full .last-col-full -->		
					</div>
				
				<!-- END .section -->
				</div>
				
				<!-- BEGIN #footer -->
				<div id="footer" class="clearfix">
					
					<!-- BEGIN .two-forths -->
					<div class="two-forths">
						
						<!-- BEGIN .widget -->
						<div class="widget">
							<div class="widget-title clearfix">
								<h5>Xuân Phú Hotel</h5>
							</div>
							<p>CÔNG TY TNHH MỘT THÀNH VIÊN PHUBK. <br>Mã số doanh nghiệp: 0401741252 <br>06 Hồ Tùng Mậu - phường Hòa Minh, quận Liên Chiểu, TP Đà Nẵng. <br> Phone: 05113.66.88.16 - Email: maixphu@gmail.com</br></p>
						<!-- END .widget -->
						</div>
					
					<!-- END .two-forths -->
					</div>
					
					<!-- BEGIN .one-forth -->
					<div class="one-forth">
						
						<!-- BEGIN .widget -->
						<div class="widget">
							<div class="widget-title clearfix">
								<h5>Liên kết nhanh</h5>
							</div>
							
							<ul>
								<li><a href="accommodation.html">Accommodation</a></li>								
								<li><a href="events.html">Khuyến mãi</a></li>
								<li><a href="contact.html">Liên hệ</a></li>
							</ul>
							
						<!-- END .widget -->
						</div>
					
					<!-- END .one-forth -->
					</div>
					
					<!-- BEGIN .one-forth -->
					<div class="one-forth last-col">
						
						<!-- BEGIN .widget -->
						<div class="widget">
							<div class="widget-title clearfix">
								<h5>Hình ảnh</h5>
							</div>
							
							<div class="flickr_badge_wrapper clearfix">
								<script type="text/javascript" src="http://www.flickr.com/badge_code_v2.gne?count=3&amp;flickr_display=latest&amp;size=s&amp;layout=x&amp;source=user&amp;user=143162021@N04"></script>								
								<div style="clear:both;"></div>
								<p class="flickr-more-photos"><a href="http://www.flickr.com/photos/143162021@N04">View More &raquo;</a></p>
							</div>
							
						<!-- END .widget -->
						</div>
						
					<!-- END .one-forth -->
					</div>
					
				<!-- END #footer -->
				</div>
				
				<!-- BEGIN #footer-bottom -->
				<div id="footer-bottom" class="clearfix">
					<p class="fl">Copyright by Phubk &copy 2016</p>
					<ul class="footer-menu fr">
						<li><a href="index.html">Trang chủ</a><span>/</span></li>
						<li><a href="accommodation.html">Đặt phòng</a><span>/</span></li>
						<li><a href="contact.html">Liên hệ</a><span>/</span></li>
					</ul>
				<!-- END #footer-bottom -->
				</div>
			
			<!-- END .content-body -->
			</div>
			
		<!-- END .content-wrapper -->
		</div>
		
	<!-- END .background-wrapper -->
	</div>

<!-- END body -->
</body>
</html>