

<?php $__env->startSection('title'); ?>
<?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="col-lg-6">
        <div class="panel panel-default">
            <div class="panel-heading">Create</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
					<form role="form" method="post" action="<?php echo e(Asset('admin/customers/create')); ?>">
						<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="form-group">
                                    <label>Name</label>
                                    <input class="form-control" name="name">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Gender</label>
                                    <select class="form-control" name="sex">                     
                                        <?php foreach($sex as $id => $name): ?>                        
                                        <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                        <?php endforeach; ?>    
                                    </select>
                                </div>
                            </div>
                        </div> 
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="form-group">
                                    <label>Date of Birth</label>
                                    <input class="form-control" id="dob" name="dob">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Nationality</label>
                                    <select class="form-control" name="nation">                     
                                        <?php foreach($nation as $id => $name): ?>                        
                                        <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                        <?php endforeach; ?>    
                                    </select>
                                </div>
                            </div>
                        </div>   
                        <div class="form-group">
                            <label>Address</label>
                            <input class="form-control" name="address">
                        </div>       
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="form-group">
                                    <label>Document No</label>
                                    <input class="form-control" name="document_no">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Document Type</label>
                                    <select class="form-control" name="document_id">                     
                                        <?php foreach($document_type as $id => $name): ?>                        
                                        <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                        <?php endforeach; ?>    
                                    </select>
                                </div>
                            </div>
                        </div>                   
                        <div class="form-group">
                            <label>Note</label>
                            <textarea class="form-control" rows="5" name="note"></textarea>
                        </div>                                              
						<button type="submit" class="btn btn-default">Submit</button>
					</form>
                <!-- /.table-responsive -->
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->
    <div class="col-lg-6">
        <div class="panel panel-default">
            <div class="panel-heading">Customers</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
                <div class="table-responsive">
                    <table class="table table-hover table-condensed">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Gender</th>                                
                                <th>License</th>
                                <th>DOB</th>
                                <th>Nationality</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        	<?php foreach($customers as $customer): ?>
                            <tr>
                                <td><?php echo e($customer -> name); ?></td>
                                <td><?php echo e($sex[$customer -> sex]); ?></td>
                                <td><?php echo e($customer -> document_num); ?></td>
                                <td><?php echo e($customer -> dob); ?></td>
                                <td><?php echo e($nation[$customer -> nation]); ?></td>
                                
                                <td>									
									<a href='edit/<?php echo e($customer -> id); ?>' class='btn btn-primary btn-xs'><i class='fa fa-edit'></i></a>
									<a href='destroy/<?php echo e($customer -> id); ?>' class='btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a>
								</td>                               
                            </tr>
                            <?php endforeach; ?>                            
                        </tbody>
                    </table>
                </div>
                <!-- /.table-responsive -->
                <div style="text-align: center"><?php echo e($customers -> links()); ?></div>
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->
</div>


<!-- Include Required Prerequisites -->
<script type="text/javascript" src="//cdn.jsdelivr.net/jquery/1/jquery.min.js"></script>
<script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap/latest/css/bootstrap.css" />
 
<!-- Include Date Range Picker -->
<script type="text/javascript" src="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.js"></script>
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css" />

<script type="text/javascript">
$('#dob').daterangepicker({
    "singleDatePicker": true,
    "minDate": 0,
}, function(start, end, label) {
  console.log("New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')");
});
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('template.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>