<?php $__env->startSection('title'); ?>
<span>Reception</span><span class="pull-right">Current Time: <?php echo e(date('d-m-Y H:i')); ?></span>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <?php foreach($items as $item): ?>
    <div class="col-lg-4">
        <?php if(App\Billing::where('item_id', '=', $item -> id) -> count() > 0): ?>
        <div class="panel panel-red">
        <?php else: ?>
        <div class="panel panel-info">
        <?php endif; ?>
            <?php
                $b = DB::table('billings')->where('item_id', $item -> id)->first();
            ?>
            <div class="panel-heading">
                <?php if(App\Billing::where('item_id', '=', $item -> id) -> count()): ?>
                <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                <span class="pull-left" data-toggle="modal" data-target="#myPayment" id="paymentId" roomId="<?php echo e($item -> id); ?>" customerId="<?php echo e($b->customer_id); ?>">P<?php echo e($item->name); ?></span>
                <?php else: ?>
                <span class="pull-left">P<?php echo e($item->name); ?></span>
                <?php endif; ?>
                <span class="pull-right"><?php if(App\Billing::where('item_id', '=', $item -> id) -> count()): ?><i class="fa fa-plus-square" data-toggle="modal" data-target="#myModal" id="cid" cId="<?php echo e($b->customer_id); ?>"></i><?php endif; ?></span>
                <div class="clearfix"></div>
            </div>
            <div class="panel-body"> 
                <?php if(App\Billing::where('item_id', '=', $item -> id) -> count()): ?>                
                <li><i class="fa fa-users"></i> <?php echo e(App\Customer::find($b->customer_id) -> name); ?> - [<?php echo e(App\Customer::find($b->customer_id) -> document_num); ?>]</li>
                <li><i class="fa fa-calendar" aria-hidden="true"></i>: <b><?php echo e(date("d-m-Y", strtotime($b -> date_from))); ?></b> - 
                    <i class="fa fa-clock-o" aria-hidden="true"></i>: <b><?php echo e(date("H:i", strtotime($b -> hour_from))); ?></b>                    
                </li>
                <li><i class="fa fa-calendar" aria-hidden="true"></i>: <b><?php echo e(date("d-m-Y", strtotime($b -> date_to))); ?></b> - <i class="fa fa-clock-o" aria-hidden="true"></i>: <b><?php echo e(date("H:i", strtotime($b -> hour_to))); ?></b></li>
                <li><a href="<?php echo e(Asset('admin/billings/invoice')); ?>/<?php echo e($b->customer_id); ?>">Pay</a></li>
                <?php else: ?>
                <li id="phubk" roomId="<?php echo e($item->id); ?>"><i class="fa fa-user" aria-hidden="true" data-toggle="modal" data-target="#myModal2"></i></li>
                <li><i class="fa fa-calendar" aria-hidden="true"></i>:  - <i class="fa fa-clock-o" aria-hidden="true"></i>: <b></b></li>
                <li><i class="fa fa-calendar" aria-hidden="true"></i>:  - <i class="fa fa-clock-o" aria-hidden="true"></i>: <b></b></li>
                <?php endif; ?>
            </div>
            <div class="panel-footer text-right">
                <?php
                    if($b){
                        //Xu ly gio
                        $hour_current = strtotime(date("H:i:s"));
                        $hour_from = strtotime($b -> hour_from);

                        if(($hour_current - $hour_from) > 0){
                            $distance = ($hour_current - $hour_from);                           
                        }else{
                            $distance = 86400 + $hour_current - $hour_from;
                        }
                        //Xu ly ngay
                        $date_current = strtotime(date("Y-m-d"));
                        $date_from = strtotime($b -> date_from);
                        $datediff = $date_current - $date_from;
                        $dateNum = floor($datediff/86400);

                        $hour = floor($distance/3600);  // So gio 
                        $minus = floor($distance/60)%60; 
                        $price_hour = array(); // Tong tien theo gio

                        if($dateNum > 0 || $hour > 10){
                            $price_hour[0] = $item -> price;
                        }else if($hour < 7){
                            // TINH TIEN GIO
                            if($hour < 1){

                                $price_hour[0] = 0;

                                if($minus > 5 && $minus < 30){
                                    $price_hour[0] = 50;
                                }
                                if($minus >= 30 && $minus < 60){
                                    $price_hour[0] = 60;
                                }

                            }else{
                                for ($i=0; $i < $hour ; $i++) { 
                                    $price_hour[0] = 60;
                                    if($minus < 30){
                                        $price_hour[$i+1] = 10;
                                    }else{
                                        $price_hour[$i+1] = 20;   
                                    }                                    
                                }                                
                            }                            
                            
                        }else{
                            // TINH TIEN QUA DEM [6 - 12]
                            $price_hour[0] = 160;
                        }

                    }else{
                        $price_hour = array();  // Tong so tien theo gio
                        $distance = 0;
                        $dateNum = 0;
                    }
                ?>
                <strong>Date: <?php echo e($dateNum); ?> - Hour: <?php echo e(floor($distance/3600)); ?> - Minus: <?php echo e(floor($distance/60)%60); ?> - Amount: $<?php echo e(number_format(array_sum($price_hour),0)); ?></strong>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<script src="http://code.jquery.com/jquery-1.11.1.min.js"></script>
<script type="text/javascript">
    $(document).on('click', '#phubk',function(e) {
        var roomId = $(this).attr("roomId");
        $("#jRoomId").val(roomId);
    });

    $(document).on('click', '#cid',function(e) {
        var cId = $(this).attr("cId");
        $("#customer_id").val(cId);
    });

    $(document).on('click', '#paymentId',function(e) {
        var customerId = $(this).attr("customerId");
        var token       = $('input[name="_token"]').val();          
        var content     = "customerId="+customerId+"&_token="+token;
        jQuery.ajax({
            type: "GET", // HTTP method POST or GET
            url: "<?php echo e(Asset('admin/billings/billing-ajax')); ?>", //Where to make Ajax calls                
            dataType: 'json',
            data: content, //post variables
            success:function(response) {
                if(response.success) {
                    $.each(response.customerservices, function(key, value) {
                        console.log(key + ": " + value);                        
                        $("#myTable tr:last").after('<tr><td>'+value["id"] +'</td><td>'+value["service_id"]+'</td><td>'+value["quantity"]+'</td><td>'+value["price"]+'</td><td>'+value["discount"]+'</td><td>'+value["price"]*value["quantity"]+'</td></tr>');
                    });         
                } else {
                    alert("Bạn không có quyền thực hiện chức năng này.");
                }
            },
            error:function (xhr, ajaxOptions, thrownError){
                alert(thrownError); //throw any errors
            }
        });
    });
</script>

<!-- Modal -->
<div class="modal fade" id="myPayment" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title" id="myModalLabel">Billings</h4>
            </div>
            <div class="modal-body">
                <form role="form" method="post" action="<?php echo e(Asset('admin/billings/cservice')); ?>">
                    <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                    <!-- <input type="hidden" name="customer_id" id="customer_id">   --> 
                    <table class="table table-hover" id ="myTable">
                        <tr class="danger">
                            <th colspan="7">Rooms</th>                            
                        </tr>
                        <tr>
                            <th>#</th>
                            <th>From</th>
                            <th>To</th>
                            <th>Rooms</th>
                            <th>Price</th>
                            <th>Discount</th>
                            <th>Amount</th>
                        </tr>                        
                        <tr class="danger">
                            <th colspan="7">Service</th>                            
                        </tr>
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Qty</th>
                            <th>Price</th>
                            <th>Discount</th>
                            <th>Amount</th>
                            <th>Action</th>
                        </tr>                       
                    </table>
                   <!--  <button type="submit" class="btn btn-default">Submit</button> -->
                <!-- </form> -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Submit</button>
            </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->


<!-- Modal -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title" id="myModalLabel">Services</h4>
            </div>
            <div class="modal-body">
                <form role="form" method="post" action="<?php echo e(Asset('admin/billings/cservice')); ?>">
                    <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                    <input type="hidden" name="customer_id" id="customer_id">                    
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label>Service Name</label>
                                <select class="form-control" name="sv_id">                     
                                    <?php foreach($services as $id => $name): ?>                        
                                    <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                    <?php endforeach; ?>    
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-3">
                            <div class="form-group">
                                <label>Qty.</label>
                                <input class="form-control" name="quantity" value="0">
                            </div>
                        </div>                        
                        <div class="col-lg-3">
                            <div class="form-group">
                                <label>Discount(%)</label>
                                <input class="form-control" name="discount" value="0">
                            </div>
                        </div>
                    </div>
                   <!--  <button type="submit" class="btn btn-default">Submit</button> -->
                <!-- </form> -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Submit</button>
            </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!-- Modal -->
<div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title" id="myModalLabel">Customers</h4>
            </div>
            <div class="modal-body"> 
                <!-- Nav tabs -->
                <ul class="nav nav-tabs">
                    <li class="active"><a data-toggle="tab" href="#home-pills" aria-expanded="true">New Customer</a>
                    </li>
                    <li class=""><a data-toggle="tab" href="#profile-pills" aria-expanded="false">Exist Customers</a>
                    </li>
                </ul>
                <?php
                    $sex = array("Nam", "Nữ", "Khác");
                    $nation = array("Việt Nam", "Hoa Kỳ", "Trung Quốc", "Hàn Quốc", "Đức", "Thái Lan", "Anh", "Khác");
                    $document_type = array("CMND", "Giấy phép lái xe", "Giấy tờ khác", "Hộ chiếu");
                ?>
                <!-- Tab panes -->
                <div class="tab-content">
                    <div id="home-pills" class="tab-pane fade active in">
                        <form role="form" method="post" action="<?php echo e(Asset('admin/billings/reception')); ?>">
                        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                        <input type="hidden" name="jRoomId" id="jRoomId">
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="form-group">
                                    <label>Name</label>
                                    <input class="form-control" name="name">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Gender</label>
                                    <select class="form-control" name="sex">                     
                                        <?php foreach($sex as $id => $name): ?>                        
                                        <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                        <?php endforeach; ?>    
                                    </select>
                                </div>
                            </div>
                        </div> 
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="form-group">
                                    <label>Date of Birth</label>
                                    <input class="form-control" id="dob" name="dob">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Nationality</label>
                                    <select class="form-control" name="nation">                     
                                        <?php foreach($nation as $id => $name): ?>                        
                                        <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                        <?php endforeach; ?>    
                                    </select>
                                </div>
                            </div>
                        </div>   
                        <div class="form-group">
                            <label>Address</label>
                            <input class="form-control" name="address">
                        </div>       
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="form-group">
                                    <label>Document No</label>
                                    <input class="form-control" name="document_no">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Document Type</label>
                                    <select class="form-control" name="document_id">                     
                                        <?php foreach($document_type as $id => $name): ?>                        
                                        <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                        <?php endforeach; ?>    
                                    </select>
                                </div>
                            </div>
                        </div>                   
                        <div class="form-group">
                            <label>Note</label>
                            <textarea class="form-control" rows="5" name="note"></textarea>
                        </div>                                              
                        <!-- <button type="submit" class="btn btn-default">Submit</button>
                        </form> -->
                    </div>
                    <div id="profile-pills" class="tab-pane fade">
                        <p>//UPDATE</p>
                    </div>                    
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Submit</button>
            </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!-- Include Required Prerequisites -->
<script type="text/javascript" src="//cdn.jsdelivr.net/jquery/1/jquery.min.js"></script>
<script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap/latest/css/bootstrap.css" />
 
<!-- Include Date Range Picker -->
<script type="text/javascript" src="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.js"></script>
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css" />

<script type="text/javascript">
$('#dob').daterangepicker({
    "singleDatePicker": true,
    "minDate": 0,
    locale: {
            format: 'DD/MM/YYYY'
    }
}, function(start, end, label) {
  console.log("New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')");
});

$('#date_from').daterangepicker({
    "singleDatePicker": true,
    "minDate": moment(),
    locale: {
            format: 'DD/MM/YYYY'
    },
    beforeShow: function() {
    $(this).datepicker('option', 'maxDate', $('#date_to').val());
  }
}, function(start, end, label) {
  console.log("New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')");
});

$('#date_to').daterangepicker({
    "singleDatePicker": true,
    locale: {
            format: 'DD/MM/YYYY'
    },
    beforeShow: function() {
        $(this).datepicker('option', 'minDate', $('#date_from').val());
        if ($('#date_from').val() === '') $(this).datepicker('option', 'minDate', 0);                             
     }
}, function(start, end, label) {
  console.log("New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')");
});

</script>

<script src="<?php echo e(Asset('public/template/admin/js/bootstrap-timepicker.js')); ?>"></script>
<link href="<?php echo e(Asset('public/template/admin/dist/css/bootstrap-timepicker.css')); ?>" rel="stylesheet">
<script type="text/javascript">
    $('#timepicker1').timepicker();
    $('#timepicker2').timepicker();
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('template.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>