<?php $__env->startSection('title'); ?>
<button type="submit" class="btn btn-primary">DAT PHONG</button>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="col-lg-6">
        <div class="panel panel-default">
            <div class="panel-heading">Rooms</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
                <form role="form" method="post" action="<?php echo e(Asset('admin/categories/create')); ?>">
                    <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">                    
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="form-group">
                                <label>Room Type</label>
                                <select class="form-control" name="nation">                     
                                    <?php foreach($nation as $id => $name): ?>                        
                                    <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                    <?php endforeach; ?>    
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label>Room</label>
                                <select class="form-control" name="sex">                     
                                    <?php foreach($sex as $id => $name): ?>                        
                                    <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                    <?php endforeach; ?>    
                                </select>
                            </div>
                        </div>                       
                    </div> 
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="form-group">
                                <label>Price</label>
                                <input class="form-control" name="position">
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label>Discount(%)</label>
                                <input class="form-control" name="position">
                            </div>
                        </div>                       
                    </div> 
                    
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="form-group">
                                <label>Date From</label>
                                <input class="form-control" id="date_from" name="position">
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <label>Hour From</label>              
                            <div class="input-group bootstrap-timepicker timepicker">
                                <input id="timepicker1" name="hour_detect" type="text" class="form-control">
                                <span class="input-group-addon"><i class="glyphicon glyphicon-time"></i></span>
                            </div>
                        </div>
                    </div> 
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="form-group">
                                <label>Date To</label>
                                <input class="form-control" id="date_to" name="position">
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label>Hour To</label>
                                <div class="input-group bootstrap-timepicker timepicker">
                                    <input id="timepicker2" name="hour_detect" type="text" class="form-control">
                                    <span class="input-group-addon"><i class="glyphicon glyphicon-time"></i></span>
                                </div>
                            </div>
                        </div>
                    </div> 
                    <div class="form-group">
                        <label>Note</label>
                        <textarea class="form-control" rows="2" name="note"></textarea>
                    </div>
                </form>    
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->
    <div class="col-lg-6">
        <div class="panel panel-default">
            <div class="panel-heading">Customers</div>
            <div class="panel-body">
                <form role="form" method="post" action="<?php echo e(Asset('admin/customers/create')); ?>">
                        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="form-group">
                                    <label>Name</label>
                                    <input class="form-control" name="name">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Gender</label>
                                    <select class="form-control" name="sex">                     
                                        <?php foreach($sex as $id => $name): ?>                        
                                        <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                        <?php endforeach; ?>    
                                    </select>
                                </div>
                            </div>
                        </div> 
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="form-group">
                                    <label>Date of Birth</label>
                                    <input class="form-control" id="dob" name="dob">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Nationality</label>
                                    <select class="form-control" name="nation">                     
                                        <?php foreach($nation as $id => $name): ?>                        
                                        <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                        <?php endforeach; ?>    
                                    </select>
                                </div>
                            </div>
                        </div>   
                        <div class="form-group">
                            <label>Address</label>
                            <input class="form-control" name="address">
                        </div>       
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="form-group">
                                    <label>Document No</label>
                                    <input class="form-control" name="document_no">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Document Type</label>
                                    <select class="form-control" name="document_id">                     
                                        <?php foreach($document_type as $id => $name): ?>                        
                                        <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                        <?php endforeach; ?>    
                                    </select>
                                </div>
                            </div>
                        </div>                                   
                        <div class="form-group">
                            <label>Note</label>
                            <textarea class="form-control" rows="2" name="note"></textarea>
                        </div>
                    </form>
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->
</div>

<div class="row">
    <div class="col-lg-6">
        <div class="panel panel-default">
            <div class="panel-heading">Create</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
                <!-- Button trigger modal -->
                <button class="btn btn-primary btn-lg" data-toggle="modal" data-target="#myModal">
                    Launch Demo Modal
                </button>
                <!-- Modal -->
                <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                                <h4 class="modal-title" id="myModalLabel">Modal title</h4>
                            </div>
                            <div class="modal-body">
                                <form role="form" method="post" action="<?php echo e(Asset('admin/categories/create')); ?>">
                                    <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                    <div class="form-group">
                                        <label>Name</label>
                                        <input class="form-control" name="name">
                                    </div>
                                    <div class="form-group">
                                        <label>Position</label>
                                        <input class="form-control" name="position">
                                    </div>
                                    <button type="submit" class="btn btn-default">Submit</button>
                                </form>
                                Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="button" class="btn btn-primary">Save changes</button>
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                </div>
                <!-- /.modal -->	
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->
    <div class="col-lg-6">
        <div class="panel panel-default">
            <div class="panel-heading">Floor 2nd</div>
            <div class="panel-body">
                <button type="submit" class="btn btn-primary">PHONG 201</button>
                <button type="submit" class="btn btn-danger">PHONG 201</button>
                <button type="submit" class="btn btn-primary">PHONG 201</button>
                <button type="submit" class="btn btn-danger">PHONG 201</button>
                <button type="submit" class="btn btn-primary">PHONG 201</button>
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->
</div>


<!-- Include Required Prerequisites -->
<script type="text/javascript" src="//cdn.jsdelivr.net/jquery/1/jquery.min.js"></script>
<script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap/latest/css/bootstrap.css" />
 
<!-- Include Date Range Picker -->
<script type="text/javascript" src="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.js"></script>
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css" />

<script type="text/javascript">
$('#dob').daterangepicker({
    "singleDatePicker": true,
    "minDate": 0,
    locale: {
            format: 'DD/MM/YYYY'
    }
}, function(start, end, label) {
  console.log("New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')");
});

$('#date_from').daterangepicker({
    "singleDatePicker": true,
    "minDate": moment(),
    locale: {
            format: 'DD/MM/YYYY'
    },
    beforeShow: function() {
    $(this).datepicker('option', 'maxDate', $('#date_to').val());
  }
}, function(start, end, label) {
  console.log("New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')");
});

$('#date_to').daterangepicker({
    "singleDatePicker": true,
    locale: {
            format: 'DD/MM/YYYY'
    },
    beforeShow: function() {
        $(this).datepicker('option', 'minDate', $('#date_from').val());
        if ($('#date_from').val() === '') $(this).datepicker('option', 'minDate', 0);                             
     }
}, function(start, end, label) {
  console.log("New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')");
});

</script>

<script src="<?php echo e(Asset('public/template/admin/js/bootstrap-timepicker.js')); ?>"></script>
<link href="<?php echo e(Asset('public/template/admin/dist/css/bootstrap-timepicker.css')); ?>" rel="stylesheet">
<script type="text/javascript">
    $('#timepicker1').timepicker();
    $('#timepicker2').timepicker();
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('template.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>