@extends('template.admin')

@section('title')
CustomerID: {{$user->id}}
@stop

@section('content')
<div class="row">
    <div class="col-lg-12">
        @if (count($errors) > 0)
            <div class="alert alert-warning" role="alert">
                @foreach ($errors->all() as $error)
                    {{ $error }}
                @endforeach
            </div>
        @endif
        <div class="panel panel-default">
            <div class="panel-heading">Edit</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
					<form role="form" method="post" action="{{Asset('admin/users/edit')}}/{{$user->id}}">
						<input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <div class="form-group">
                            <label>Name</label>
                            <input class="form-control" name="name" value="{{$user->name}}">
                        </div> 
                        <div class="form-group">
                            <label>Email</label>
                            <input class="form-control" name="email" value="{{$user->email}}" disabled>
                        </div>    
                        <div class="form-group">
                            <label>Password</label>
                            <input type="password" class="form-control" name="password">
                        </div> 
                        <div class="form-group">
                            <label>Re-type Password</label>
                            <input type="password" class="form-control" name="password_confirmation">
                        </div>                                              
						<button type="submit" class="btn btn-default">Submit</button>
					</form>
                <!-- /.table-responsive -->
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->    
</div>
@stop