<!DOCTYPE html>
<!--[if lt IE 7]> <html dir="ltr" lang="en-US" class="ie6"> <![endif]-->
<!--[if IE 7]>    <html dir="ltr" lang="en-US" class="ie7"> <![endif]-->
<!--[if IE 8]>    <html dir="ltr" lang="en-US" class="ie8"> <![endif]-->
<!--[if gt IE 8]><!--> <html dir="ltr" lang="en-US"> <!--<![endif]-->

<!-- BEGIN head -->
<head>

	<!--Meta Tags-->
	<meta name="viewport" content="width=device-width; initial-scale=1.0">
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta charset="UTF-8">
	<meta name="description" content="Khách sạn xuân Phú, Xuân Phú Hotel, Khách sạn tại Đà Nẵng, Khách sạn ven biển, Khách sạn đường Nguyễn Tất Thành, Khách sạn Liên Chiểu, Khách sạn 2 sao, Khách sạn ĐƯờng Hồ Tung Mau, Liên Chiểu, Ho Tung Mau, Khach san gia rẻ">
	<meta name="keywords" content="Khách sạn Xuân Phú, Xuân Phú Hotel, xuan phu hotel da nang, khach san xuan phu, xuan phu, khach san gia re, Khách sạn ven biển, Khách sạn đường Nguyễn Tất Thành, Khách sạn Liên Chiểu, Khách sạn 2 sao, Khách sạn ĐƯờng Hồ Tung Mau, Liên Chiểu, Ho Tung Mau, Khach san gia rẻ">
	<meta name="author" content="Xuân Phú Hotel">
	<meta name="google-site-verification" content="z-6MrJr334oAOOqyqQ3TVxpTWT7qZn-k1ARnRMre_RM">
	<!--Title-->
	<title>Xuân Phú Hotel - Khách Sạn Xuân Phú Đà Nẵng</title>

	<!--Stylesheets-->
	<link rel="stylesheet" href="{{Asset('public/template/css/superfish.css')}}" type="text/css"  media="all"  />
	<link rel="stylesheet" href="{{Asset('public/template/css/prettyPhoto.css')}}" type="text/css" media="all" />
	<link rel="stylesheet" href="{{Asset('public/template/css/responsive.css')}}" type="text/css" media="all" />
	<link type="text/css"  href="{{Asset('public/template/css/jqueryui/jquery.ui.datepicker.css')}}" rel="stylesheet" />
	<link rel="stylesheet" href="{{Asset('public/template/style.css')}}" type="text/css"  media="all"  />
	<link rel="stylesheet" href="{{Asset('public/template/css/colours/cream-red.css')}}" type="text/css"  media="all"  />
	<link href='http://fonts.googleapis.com/css?family=Cardo:400,400italic,700' rel='stylesheet' type='text/css'>

	<!--Favicon-->
	<link rel="shortcut icon" href="{{Asset('public/favicon.ico')}}" type="image/x-icon" />

	<!--JavaScript-->
	<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.7/jquery.min.js"></script>
	<script type='text/javascript' src='http://ajax.googleapis.com/ajax/libs/jqueryui/1.8/jquery-ui.min.js'></script>
	<script type="text/javascript" src="{{Asset('public/template/js/jquery.ui.core.js')}}"></script>
	<script type="text/javascript" src="{{Asset('public/template/js/jquery.ui.widget.js')}}"></script>
	<script type="text/javascript" src="{{Asset('public/template/js/jquery.ui.datepicker.js')}}"></script>
	<script type='text/javascript' src="{{Asset('public/template/js/jquery.prettyPhoto.js')}}"></script>
	<script type="text/javascript" src="{{Asset('public/template/js/superfish.js')}}"></script>
	<script type="text/javascript" src="{{Asset('public/template/js/slides.min.jquery.js')}}"></script>
	<script type="text/javascript" src="{{Asset('public/template/js/scripts.js')}}"></script>
	
	<!--[if (gte IE 6)&(lte IE 8)]>
		<script type="text/javascript" src="js/selectivizr-min.js"></script>
	<![endif]-->

<!-- END head -->
</head>
<script>
  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
  })(window,document,'script','https://www.google-analytics.com/analytics.js','ga');

  ga('create', 'UA-83558910-1', 'auto');
  ga('send', 'pageview');

</script>
<!-- BEGIN body -->
<body>

	<!-- BEGIN .background-wrapper -->
	<div class="background-wrapper">
		
		<!-- BEGIN .content-wrapper -->
		<div class="content-wrapper">
		
			<!-- BEGIN .content-body -->
			<div class="content-body">
				
				<!-- BEGIN #header-google-map -->
				<div id="header-google-map" style="display:none;">
					<script type="text/javascript" src="http://maps.google.com/maps/api/js"></script>
					<script type="text/javascript" src="{{Asset('public/template/js/gmap.js')}}"></script>
					<div id="map_canvas" style="width:100%;height:300px;"></div>
				<!-- END #header-google-map -->
				</div>
				
				<!-- BEGIN .top-bar -->
				<div class="top-bar clearfix">
					
					<!-- BEGIN .social-icons -->
					<ul class="social-icons fl">
						<li><a href="https://www.facebook.com/Xuanphuhotel/"><span id="facebook_icon"></span></a></li>
						<li><a href="#"><span id="skype_icon"></span></a></li>
					<!-- END .social-icons -->
					</ul>
					
					<!-- BEGIN .gmap-btn-wrapper -->
					<div class="gmap-btn-wrapper">
						<a href="#" class="gmap-btn"></a>
						<div class="gmap-curve"></div>
					<!-- END .gmap-btn-wrapper -->
					</div>
					
					<!-- BEGIN .top-menu-wrapper -->
					<div class="top-menu-wrapper fr clearfix">
						<a href="{{Asset('home/all-room')}}" class="bookbutton">ĐẶT PHÒNG</a>
						<!-- <ul class="top-menu fr">
							<li><a href="#">En</a><span> /</span></li>
							<li><a href="#">Vn</a></li>
						</ul> -->
					<!-- END .top-menu-wrapper -->
					</div>
					
				<!-- END .top-bar -->
				</div>
				
				<!-- BEGIN .title-wrapper -->
				<div id="title-wrapper">
					<h1><div class="title-dec-left"></div><a href="{{Asset('home/index')}}">Xuân Phú Hotel <span>Khách Sạn Xuân Phú</span></a><div class="title-dec-right"></div></h1>
				<!-- END .title-wrapper -->
				</div>
				
				<!-- BEGIN #navigation -->
				<div id="navigation" class="clearfix">
					
					<!-- BEGIN #main-menu -->
					<ul id="main-menu" class="fl clearfix">
						<li class="current-menu-item"><a href="{{Asset('home/index')}}">Trang chủ<span>start here</span></a></li>
						<li><a href="{{Asset('home/all-room')}}">Loại phòng<span>rates &amp; reservations</span></a>
							<ul>
								@foreach(App\Room::all() as $room)
								<li><a href="{{Asset('home/room-detail')}}/{{$room -> id}}">{{$room -> name}}</a></li>
								@endforeach								
							</ul>
						</li>
					<!-- END #main-menu -->
					</ul>
					
					<ul class="main-menu-contact-info fr">
						<li class="info-phone">02363.66 88 16 - 0976 04.05.66</li>
						<li class="info-email">xuanphuhotel@gmail.com</li>
					</ul>
					
					<div class="corner-left"></div>
					<div class="corner-right"></div>
					
				<!-- END #navigation -->
				</div>
				
				<!-- BEGIN #slides -->
				<div id="slides" class="slide-loader">
					
					<!-- BEGIN .slides_container -->
					<div class="slides_container">
						
						<div class="slide">
							<img src="{{Asset('public/template/images/slide3.png')}}" alt="Khách sạn Xuân Phú Đà Nẵng" />
							<div class="caption">Superior Double Room</div>
						</div>
						
						<div class="slide">
							<a href="{{Asset('home/all-room')}}"><img src="{{Asset('public/template/images/slide2.png')}}" alt="Khách sạn Xuân Phú" /></a>
							<div class="caption">Deluxe Double Room</div>
						</div>
				
					<!-- END .slides_container -->
					</div>

					<a href="#" class="prev">Previous</a>
					<a href="#" class="next">Next</a>
					
					<!-- BEGIN .booknow -->
					<div class="booknow">
						
						<form class="booking-form" name="bookroom" action="{{Asset('home/booking-index')}}" method="get">							
							<div class="select-wrapper">
								<select id="room_id" name="room_id">
									@foreach(App\Room::all() as $ro)
									<option value="{{$ro->id}}">{{$ro->name}}</option>
									@endforeach									
								</select>
							</div>
							
							<div class="clearfix">
								<input type="text" id="datefrom" name="datefrom" value="From" class="input-half datepicker">
								<input type="text" id="dateto" name="dateto" value="To" class="input-half input-half-last datepicker">
							</div>						
							<input class="bookbutton" type="submit" value="ĐẶT PHÒNG" />						
						</form>						
						<div class="corner-left"></div>
					<!-- END .booknow -->
					</div>
			
				<!-- END #slides -->
				</div>
			
				<h2 class="intro-msg">Xuân Phú Hotel là một khách sạn hiện đại và đẳng cấp. Tọa lạc ở vị trí đắc địa tại trung tâm quận Liên Chiểu và nằm ngay sát biển. Quý khách dễ dàng ngắm bình minh trên biển tận hưởng sự sôi động của con đường du lịch Nguyễn Tất Thành khi đêm về.</h2>
				
				<hr>

				<!-- BEGIN .section -->
				<div class="section home-blocks clearfix">

					<div class="one-third-full">	
						<h3 class="title1">Tin tức & sự kiện<span class="title-end"></span></h3>
						<p><div class="block-img1"><img src="#" width="278" height="80" alt="Xuan Phu Hotel" /></div></p>
						
						<p style="text-align: justify"></p>
						<p><a href="#" class="button2">Xem thêm &raquo;</a></p>			
					</div>

					<div class="one-third-full featured-wrapper">
						<h3 class="title1">Tiện nghi Khách sạn<span class="title-end"></span></h3>
						<ul class="list3">
							<li>20 phòng khách tiện nghi hiện đại</li>
							<li>Thang máy</li>
							<li>Cho thuê xe</li>
							<li>Đưa đón tại sân bay</li>
							<li>Wifi miễn phí</li>
							<li>Bãi đậu xe</li>
						</ul>
						<div class="featured-bottom"></div>	
					</div>

					<style type="text/css">
						#pimg{
							width: 278px;
    						height: 80px;
						}						
					</style>
					
					<div class="one-third-full">	
						<h3 class="title1">Lý do chọn Xuân Phú Hotel?<span class="title-end"></span></h3>
						<p><div class="block-img1"><img id="pimg" src="{{Asset('public/template/images/why.jpg')}}" width="278" height="80" alt="Xuan Phu Hotel"  /></div></p>
						<p style="text-align: justify">Chỉ cách biển vài bước chân, gần những danh thắng nổi tiếng như phố cố Hội An, cố đô Huế, Bà Nà Hills.</p>
						<p><a href="{{Asset('home/reason')}}" class="button2">Xem thêm &raquo;</a></p>			
					</div>

				<!-- END .section -->
				</div>
				
				<hr>
				
				<!-- BEGIN .section -->
				<div class="section clearfix">
					
					<!-- BEGIN .one-half-full -->
					<div class="one-half-full">	
						
						<div class="testimonial-wrapper clearfix">
							<img src="{{Asset('public/template/images/nsinh.jpg')}}" width="65" height="65" alt="Khách sạn Xuân Phú" class="testimonial-guest" />
							<p class="testimonial-text">Đến với Xuân Phú Hotel để cảm nhận vẻ đẹp hoang sơ, tinh khiết của tự nhiên. Nơi chúng ta có thể cảm nhận “một ngày bốn mùa”, tận hưởng không khí trong lành và ngắm nhìn nhiều cảnh quan tuyệt vời của ĐN.</p>
							<div class="testimonial-speech"></div>
						</div>
						
						<p class="testimonial-author">Nguyễn Nhật Sinh - <span>Double Ensuite Room</span></p>
					
					<!-- END .one-half-full -->			
					</div>
					
					<!-- BEGIN .one-half-full .last-col-full -->
					<div class="one-half-full last-col-full">	
						
						<div class="testimonial-wrapper clearfix">
							<img src="{{Asset('public/template/images/ntuan.jpg')}}" width="65" height="65" alt="Khách sạn Xuân Phú" class="testimonial-guest" />
							<p class="testimonial-text">Ai ghé Đà Nẵng mà còn băn khoăn chỗ nghỉ nghơi thì cứ đến thẳng Xuân Phú Hotel nhé. Cam kết phục vụ tận tình, chu đáo.</p>
							<div class="testimonial-speech"></div>
						</div>
						
						<p class="testimonial-author">Ngô Minh Tuấn - <span>Double Duplex Room</span></p>
					
					<!-- END .one-half-full .last-col-full -->		
					</div>
				
				<!-- END .section -->
				</div>				
				<!-- BEGIN #footer-bottom -->
				<div id="footer-bottom" class="clearfix">
					<p class="fl">Copyright by Phubk &copy 2016</p>
					<ul class="footer-menu fr">
						<li><a href="{{Asset('home/index')}}">Trang chủ</a><span>/</span></li>
						<li><a href="{{Asset('home/all-room')}}">Đặt phòng</a><span>/</span></li>
						<li><a href="{{Asset('home/index')}}">Liên hệ</a><span>/</span></li>
					</ul>
				<!-- END #footer-bottom -->
				</div>
			
			<!-- END .content-body -->
			</div>
			
		<!-- END .content-wrapper -->
		</div>
		
	<!-- END .background-wrapper -->
	</div>

<!-- END body -->
<script type="text/javascript">
$('#datefrom').datepicker(
         { 
            minDate: 0,
            beforeShow: function() {
            $(this).datepicker('option', 'maxDate', $('#dateto').val());
          }
       });
$('#dateto').datepicker(
         {
            defaultDate: "+1w",
            beforeShow: function() {
            $(this).datepicker('option', 'minDate', $('#datefrom').val());            
			if ($('#datefrom').val() === '') $(this).datepicker('option', 'minDate', 'today');                             
         }
       });
$('#datefrom').datepicker('setDate', 'today');
$('#dateto').datepicker('setDate', '+1w');

</script>
</body>
</html>