@extends('template.admin')

@section('title')
FacilityID: {{$facility->id}}
@stop

@section('content')

<div class="row">
    <div class="col-lg-12">
        @if (count($errors) > 0)
            <div class="alert alert-warning" role="alert">
                @foreach ($errors->all() as $error)
                    {{ $error }}
                @endforeach
            </div>
        @endif        
        <div class="panel panel-default">
            <div class="panel-heading">Edit</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
                <div class="table-responsive">
					<form role="form" method="post" action="{{Asset('admin/facilities/edit')}}/{{$facility->id}}">
						<input type="hidden" name="_token" value="{{ csrf_token() }}">
						<div class="form-group">
							<label>Name</label>
							<input class="form-control" name="name" value="{{$facility -> name}}">
						</div>
						<button type="submit" class="btn btn-default">Submit</button>
					</form>
                </div>
                <!-- /.table-responsive -->
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->    
</div>
@stop