<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Category;
use App\Room;

class RoomController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function getIndex(){
    	$rooms = Room::all();
    	return view('rooms.index')
    		->with('title', "Rooms")
    		->with('rooms', $rooms);
    }

    public function postCreate(Request $request){
    	$room = new Room;
    	$room -> name = $request -> name;    
        $room -> description = $request -> description; 
        $room -> price = $request -> price; 
        $room -> image = $request -> image; 
        $room -> people = $request -> people; 	
    	$room -> save();
    	return back();
    }

    public function getEdit($id){
        $room = Room::find($id);
        return view('rooms.edit')
            ->with('room', $room);
    }


    public function postEdit(Request $request, $id){
        $room = Room::find($id);
        $room -> name = $request -> name; 
        $room -> description = $request -> description; 
        $room -> price = $request -> price; 
        $room -> image = $request -> image; 
        $room -> people = $request -> people;   
        $room -> save();
        return back()->withErrors('Room has been updated.');
    }

    public function getDestroy($id){
        $room = Room::find($id);
        if($room){
            $room -> delete();
            return back();
        }
        return back();
    }

    public function getActive($id){

        $room = Room::find($id);      
        if($room){    
            $room -> active = !$room -> active;
            $room -> save();
            return back();
        }   
        return back();
    }
}
