

<?php $__env->startSection('title'); ?>
<form role="form" method="post" action="<?php echo e(Asset('admin/billings/create')); ?>">
<button type="submit" class="btn btn-warning">BOOKING</button>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="col-lg-6">
        <div class="panel panel-default">
            <div class="panel-heading">Rooms</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
                <!-- <form role="form" method="post" action="<?php echo e(Asset('admin/billings/create')); ?>"> -->
                    <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">                    
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="form-group">
                                <label>Room Type</label>
                                <select id="first-choice" class="form-control" name="room_id">  
                                    <option value="0" style="text-align-last:center">PLEASE SELECT ROOM TYPE</option>                   
                                    <?php foreach($roomType as $id => $name): ?>                        
                                    <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                    <?php endforeach; ?>    
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label>Room</label>
                                <select class="form-control" name="item_id" id="mySelect">
                                </select>
                            </div>
                        </div>                       
                    </div> 
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="form-group">
                                <label>Price</label>
                                <input id="price" class="form-control" name="price" value="0">
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label>Discount(%)</label>
                                <input class="form-control" name="discount" value="0">
                            </div>
                        </div>                       
                    </div> 
                    
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="form-group">
                                <label>Date From</label>
                                <input class="form-control" id="date_from" name="date_from">
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <label>Hour From</label>              
                            <div class="input-group bootstrap-timepicker timepicker">
                                <input id="timepicker1" name="hour_from" type="text" class="form-control">
                                <span class="input-group-addon"><i class="glyphicon glyphicon-time"></i></span>
                            </div>
                        </div>
                    </div> 
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="form-group">
                                <label>Date To</label>
                                <input class="form-control" id="date_to" name="date_to">
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label>Hour To</label>
                                <div class="input-group bootstrap-timepicker timepicker">
                                    <input id="timepicker2" name="hour_to" type="text" class="form-control">
                                    <span class="input-group-addon"><i class="glyphicon glyphicon-time"></i></span>
                                </div>
                            </div>
                        </div>
                    </div> 
                    <div class="form-group">
                        <label>Note</label>
                        <textarea class="form-control" rows="2" name="note"></textarea>
                    </div>
                <!-- </form> -->    
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->
    <div class="col-lg-6">
        <div class="panel panel-default">
            <div class="panel-heading">Customers</div>
            <div class="panel-body">
                <!-- <form role="form" method="post" action="<?php echo e(Asset('admin/customers/create')); ?>"> -->
                        <!-- <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>"> -->
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="form-group">
                                    <label>Name</label>
                                    <input class="form-control" name="name">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Gender</label>
                                    <select class="form-control" name="sex">                     
                                        <?php foreach($sex as $id => $name): ?>                        
                                        <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                        <?php endforeach; ?>    
                                    </select>
                                </div>
                            </div>
                        </div> 
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="form-group">
                                    <label>Date of Birth</label>
                                    <input class="form-control" id="dob" name="dob">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Nationality</label>
                                    <select class="form-control" name="nation">                     
                                        <?php foreach($nation as $id => $name): ?>                        
                                        <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                        <?php endforeach; ?>    
                                    </select>
                                </div>
                            </div>
                        </div>   
                        <div class="form-group">
                            <label>Address</label>
                            <input class="form-control" name="address">
                        </div>       
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="form-group">
                                    <label>Document No</label>
                                    <input class="form-control" name="document_no">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Document Type</label>
                                    <select class="form-control" name="document_id">                     
                                        <?php foreach($document_type as $id => $name): ?>                        
                                        <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                        <?php endforeach; ?>    
                                    </select>
                                </div>
                            </div>
                        </div>                                   
                        <div class="form-group">
                            <label>Note</label>
                            <textarea class="form-control" rows="2" name="note"></textarea>
                        </div>
                    </form>
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->
</div>


<script src="http://code.jquery.com/jquery-1.11.1.min.js"></script>
<script type="text/javascript">
    $(document).ready(function(){
        $("#first-choice").change(function() {
            $("#price").empty();
            $("#mySelect").empty();
            var productId   = $("#first-choice").val();         
            var token       = $('input[name="_token"]').val();          
            var content     = "productId="+productId+"&_token="+token; 
            //alert(productId);
            jQuery.ajax({
                type: "GET", // HTTP method POST or GET
                url: "<?php echo e(Asset('admin/billings/active-ajax')); ?>", //Where to make Ajax calls                
                dataType: 'json',
                data: content, //post variables
                success:function(response) {
                    if(response.success) {
                        $("#price").val(response.price);
                        $.each( response.rooms, function( key, value ) {
                            $('#mySelect').append($('<option>', { 
                                value: key,
                                text : value 
                            }));
                        });
                        //alert(response.price);
                    } else {
                        alert("Bạn không có quyền thực hiện chức năng này.");
                    }
                },
                error:function (xhr, ajaxOptions, thrownError){
                    alert(thrownError); //throw any errors
                }
            });
        });
    });
</script>

<!-- Include Required Prerequisites -->
<script type="text/javascript" src="//cdn.jsdelivr.net/jquery/1/jquery.min.js"></script>
<script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap/latest/css/bootstrap.css" />
 
<!-- Include Date Range Picker -->
<script type="text/javascript" src="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.js"></script>
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css" />

<script type="text/javascript">
$('#dob').daterangepicker({
    "singleDatePicker": true,
    "minDate": 0,
    locale: {
            format: 'DD/MM/YYYY'
    }
}, function(start, end, label) {
  console.log("New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')");
});

$('#date_from').daterangepicker({
    "singleDatePicker": true,
    "minDate": moment(),
    locale: {
            format: 'DD/MM/YYYY'
    },
    beforeShow: function() {
    $(this).datepicker('option', 'maxDate', $('#date_to').val());
  }
}, function(start, end, label) {
  console.log("New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')");
});

$('#date_to').daterangepicker({
    "singleDatePicker": true,
    locale: {
            format: 'DD/MM/YYYY'
    },
    beforeShow: function() {
        $(this).datepicker('option', 'minDate', $('#date_from').val());
        if ($('#date_from').val() === '') $(this).datepicker('option', 'minDate', 0);                             
     }
}, function(start, end, label) {
  console.log("New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')");
});

</script>

<script src="<?php echo e(Asset('public/template/admin/js/bootstrap-timepicker.js')); ?>"></script>
<link href="<?php echo e(Asset('public/template/admin/dist/css/bootstrap-timepicker.css')); ?>" rel="stylesheet">
<script type="text/javascript">
    $('#timepicker1').timepicker();
    $('#timepicker2').timepicker();
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('template.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>