<?php $__env->startSection('title'); ?>
CustomerID: <?php echo e($customer->id); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-lg-12">
        <?php if(count($errors) > 0): ?>
            <div class="alert alert-warning" role="alert">
                <?php foreach($errors->all() as $error): ?>
                    <?php echo e($error); ?>

                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        <div class="panel panel-default">
            <div class="panel-heading">Edit</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
					<form role="form" method="post" action="<?php echo e(Asset('admin/customers/edit')); ?>/<?php echo e($customer->id); ?>">
						<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="form-group">
                                    <label>Name</label>
                                    <input class="form-control" name="name" value="<?php echo e($customer -> name); ?>">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Gender</label>
                                    <select class="form-control" name="sex">                     
                                        <?php foreach($sex as $id => $name): ?>                        
                                        <?php if($id == $customer->sex): ?>)
                                            <option value='<?php echo e($id); ?>' selected="selected"> <?php echo e($name); ?></option>
                                        <?php else: ?>
                                            <option value='<?php echo e($id); ?>' > <?php echo e($name); ?></option>
                                        <?php endif; ?>
                                        <?php endforeach; ?>    
                                    </select>
                                </div>
                            </div>
                        </div> 
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="form-group">
                                    <label>Date of Birth</label>
                                    <input class="form-control" id="dob" name="dob">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Nationality</label>
                                    <select class="form-control" name="nation">                     
                                        <?php foreach($nation as $id => $name): ?>                        
                                        <?php if($id == $customer->nation): ?>)
                                            <option value='<?php echo e($id); ?>' selected="selected"> <?php echo e($name); ?></option>
                                        <?php else: ?>
                                            <option value='<?php echo e($id); ?>' > <?php echo e($name); ?></option>
                                        <?php endif; ?>
                                        <?php endforeach; ?>    
                                    </select>
                                </div>
                            </div>
                        </div>   
                        <div class="form-group">
                            <label>Address</label>
                            <input class="form-control" name="address" value="<?php echo e($customer -> address); ?>">
                        </div>       
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="form-group">
                                    <label>Document No</label>
                                    <input class="form-control" name="document_no" value="<?php echo e($customer -> document_num); ?>">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Document Type</label>
                                    <select class="form-control" name="document_id">                     
                                        <?php foreach($document_type as $id => $name): ?>                        
                                        <?php if($id == $customer->document_id): ?>)
                                            <option value='<?php echo e($id); ?>' selected="selected"> <?php echo e($name); ?></option>
                                        <?php else: ?>
                                            <option value='<?php echo e($id); ?>' > <?php echo e($name); ?></option>
                                        <?php endif; ?>
                                        <?php endforeach; ?>    
                                    </select>
                                </div>
                            </div>
                        </div>                   
                        <div class="form-group">
                            <label>Note</label>
                            <textarea class="form-control" rows="5" name="note"><?php echo e($customer -> note); ?></textarea>
                        </div>                                              
						<button type="submit" class="btn btn-default">Submit</button>
					</form>
                <!-- /.table-responsive -->
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->    
</div>


<!-- Include Required Prerequisites -->
<script type="text/javascript" src="//cdn.jsdelivr.net/jquery/1/jquery.min.js"></script>
<script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap/latest/css/bootstrap.css" />
 
<!-- Include Date Range Picker -->
<script type="text/javascript" src="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.js"></script>
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css" />

<script type="text/javascript">
$('#dob').daterangepicker({
    "singleDatePicker": true,
    "minDate": 0,
}, function(start, end, label) {
  console.log("New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')");
});
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('template.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>