

<?php $__env->startSection('title'); ?>
<?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="col-lg-6">
        <div class="panel panel-default">
            <div class="panel-heading">Create</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
                <div class="table-responsive">
					<form role="form" method="post" action="<?php echo e(Asset('admin/services/create')); ?>">
						<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
						<div class="form-group">
							<label>Name</label>
							<input class="form-control" name="name">
						</div>
                        <div class="form-group">
                            <label>Price</label>
                            <input class="form-control" name="price">
                        </div>
                        <div class="form-group">
                            <label>Quantity</label>
                            <input class="form-control" name="quantity">
                        </div>                       
						<button type="submit" class="btn btn-default">Submit</button>
					</form>
                </div>
                <!-- /.table-responsive -->
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->
    <div class="col-lg-6">
        <div class="panel panel-default">
            <div class="panel-heading">Services</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
                <div class="table-responsive">
                    <table class="table table-hover table-condensed">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Price</th>
                                <th>Quantity</th>
                                <th>Created At</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        	<?php foreach($services as $service): ?>
                            <tr>
                                <td><?php echo e($service -> id); ?></td>
                                <td><?php echo e($service -> name); ?></td>
                                <td><?php echo e($service -> price); ?></td>
                                <td><?php echo e($service -> quantity); ?></td>
                                <td><?php echo e(date('d-m-Y', strtotime($service -> created_at))); ?></td>
                                <td>
									<?php if($service -> active): ?>
                                        <a href='active/<?php echo e($service -> id); ?>' class='btn btn-success btn-xs' data-toggle="tooltip" data-placement="top" title="OFF"><i class='fa fa-refresh'></i></a>
                                    <?php else: ?>
                                        <a href='active/<?php echo e($service -> id); ?>' class='btn btn-default btn-xs' data-toggle="tooltip" data-placement="top" title="ON"><i class='fa fa-refresh'></i></a>
                                    <?php endif; ?>
									<a href='edit/<?php echo e($service -> id); ?>' class='btn btn-primary btn-xs'><i class='fa fa-edit'></i></a>
									<a href='destroy/<?php echo e($service -> id); ?>' class='btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a>
								</td>                               
                            </tr>
                            <?php endforeach; ?>                            
                        </tbody>
                    </table>
                </div>
                <!-- /.table-responsive -->
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('template.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>