@extends('template.admin')

@section('title')
{{$title}}
@stop

@section('content')

<div class="row">
    <div class="col-lg-6">
        <div class="panel panel-default">
            <div class="panel-heading">Create</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
					<form role="form" method="post" action="{{Asset('admin/users/create')}}">
						<input type="hidden" name="_token" value="{{ csrf_token() }}">                        
                        <div class="form-group">
                            <label>Name</label>
                            <input class="form-control" name="name">
                        </div> 
                        <div class="form-group">
                            <label>Email</label>
                            <input class="form-control" name="email">
                        </div>    
                        <div class="form-group">
                            <label>Password</label>
                            <input type="password" class="form-control" name="password">
                        </div> 
                        <div class="form-group">
                            <label>Re-type Password</label>
                            <input type="password" class="form-control" name="password_confirmation">
                        </div>    
                                                            
						<button type="submit" class="btn btn-default">Submit</button>
					</form>
                <!-- /.table-responsive -->
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->
    <div class="col-lg-6">
        <div class="panel panel-default">
            <div class="panel-heading">Users</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
                <div class="table-responsive">
                    <table class="table table-hover table-condensed">
                        <thead>
                            <tr>
                            	<th>#</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        	@foreach($users as $user)
                            <tr>
                            	<td>{{$user -> id}}</td>
                                <td>{{$user -> name}}</td>
                                <td>{{$user -> email}}</td>                                
                                <td>									
									<a href='edit/{{$user -> id}}' class='btn btn-primary btn-xs'><i class='fa fa-edit'></i></a>
									<a href='destroy/{{$user -> id}}' class='btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a>
								</td>                               
                            </tr>
                            @endforeach                            
                        </tbody>
                    </table>
                </div>
                <!-- /.table-responsive -->
                <div style="text-align: center">{{$users -> links()}}</div>
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->
</div>
@stop