@extends('template.admin')

@section('title')
{{$title}}
@stop

@section('content')

<div class="row">
    <div class="col-lg-6">
        <div class="panel panel-default">
            <div class="panel-heading">Create</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
                <div class="table-responsive">
					<form role="form" method="post" action="{{Asset('admin/facilities/create')}}">
						<input type="hidden" name="_token" value="{{ csrf_token() }}">
						<div class="form-group">
							<label>Name</label>
							<input class="form-control" name="name">
						</div>
						<button type="submit" class="btn btn-default">Submit</button>
					</form>
                </div>
                <!-- /.table-responsive -->
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->
    <div class="col-lg-6">
        <div class="panel panel-default">
            <div class="panel-heading">Facilities</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
                <div class="table-responsive">
                    <table class="table table-hover table-condensed">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Created At</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        	@foreach($facilities as $fa)
                            <tr>
                                <td>{{$fa -> id}}</td>
                                <td>{{$fa -> name}}</td>
                                <td>{{date('d-m-Y', strtotime($fa -> created_at))}}</td>
                                <td>
									@if ($fa -> active)
                                        <a href='active/{{$fa -> id}}' class='btn btn-success btn-xs' data-toggle="tooltip" data-placement="top" title="OFF"><i class='fa fa-refresh'></i></a>
                                    @else
                                        <a href='active/{{$fa -> id}}' class='btn btn-default btn-xs' data-toggle="tooltip" data-placement="top" title="ON"><i class='fa fa-refresh'></i></a>
                                    @endif
									<a href='edit/{{$fa -> id}}' class='btn btn-primary btn-xs'><i class='fa fa-edit'></i></a>
									<a href='destroy/{{$fa -> id}}' class='btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a>
								</td>                               
                            </tr>
                            @endforeach                            
                        </tbody>
                    </table>
                </div>
                <!-- /.table-responsive -->
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->
</div>
@stop