<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Facility;

class FacilityController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function getIndex(){
    	$facilities = Facility::orderBy('name', 'asc') -> get();
    	return view('facilities.index')
    		->with('title', "Facilities")
    		->with('facilities', $facilities);
    }

    public function postCreate(Request $request){
    	$facility = new Facility;
    	$facility -> name = $request -> name;
    	$facility -> save();
    	return back();
    }

    public function getEdit($id){
        $facility = Facility::find($id);
        return view('facilities.edit')
            ->with('facility', $facility);
    }


    public function postEdit(Request $request, $id){
        $facility = Facility::find($id);
        $facility -> name = $request -> name;   
        $facility -> save();
        return back()->withErrors('Facility has been updated.');
    }

    public function getDestroy($id){
        $facility = Facility::find($id);
        if($facility){
            $facility -> delete();
            return back();
        }
        return back();
    }

    public function getActive($id){

		$fa = Facility::find($id);		
		if($fa){	
			$fa -> active = !$fa -> active;
			$fa -> save();
			return back();
		}	
		return back();
	}
}
